
try {
    $(document).ready(function(){
        $("#formConsultaGuia").submit(async function(event) {
            event.preventDefault();
            var guia = $("#numeroGuia").val();
            if(guia!= null){
                
                let Tresult = await datos(false,2);
                if (!Tresult){
                    $("#MessageError").html("<style>.error{color:red}</style><p class='error'>Opps! Ocurrio un error con tu consulta</p>");
                }
            }else{
                console.log("el valor sumnistrado no es valido o esta repetido");
            }
        })
        /*metodo que almacena los datos del API consultados en el api con el metodo "ConsultarJson" y que le suministra a  este el numero de la guia por medio de JQUERY y 
        guardandolo en una constante que va directamente a  el metodo "pintar datos"*/
        async function datos(expirado, intentos) {
            let access=window.localStorage.getItem("Access_token_consult")
            if (intentos==0){
                return Promise.resolve(false)
            } 
            try {
                if(expirado||!access){
                    const token = await consultarToken();
                    const consultToken = token.access_token;
                    window.localStorage.setItem("Access_token_consult",consultToken); 
                    access = consultToken
                }
                
                const datosPorGuia = await consultarJson($("#numeroGuia").val(),access);
                pintar(datosPorGuia);
                return Promise.resolve(true)

            } catch (error) {
                
                const Error = JSON.parse(error.message);
                console.error("error con los datos "+ error)
                if(Error.Mensaje_Estatus!=200){
                const resultado = await datos(true,intentos-1)
                return Promise.resolve(resultado)
                }
                return Promise.resolve(false) 
            }
        }
        /*metodo que Consulta los datos del API esperando numero de guía suministrado en el input del HTML*/
        async function consultarJson(guia,token){
            try{
            const respuesta = await fetch(""+Constantes.URL_DATOS_AZURE+"/api/Detalles/GetDetalleByGuia?guia="+guia+"&entorno=ALL",{
                method : "GET",
                headers :{
                    "Authorization": "Bearer "+token+""
                }
            });
            if(!respuesta.ok){
                throw new Error(JSON.stringify({ "Mensaje_Estatus":respuesta.status,"Mensaje_Error":"Tuvimos un error  en la consulta de datos"}));
            }
            return await respuesta.json();
        }catch(error){
               throw new Error(JSON.stringify({ "Mensaje_Estatus":401,"Mensaje_Error":"Tuvimos un error  en la consulta de datos"}));

        }
         return Promise.resolve({});   
        }
        /*Metodo utilizado para traer el token por medio de el api de autenticación*/
        async function consultarToken(){
            
            let token = await fetch(Constantes.URL_TOKEN_MICROSOFT,{
                method : "POST",
                headers : new Headers({
                    'Content-Type': 'application/form-data;charset=UTF-8',
                }),
                body: JSON.stringify({token: Constantes.TOKEN_WEBHOOK})
            });
            debugger;
            if(!token.ok){
                throw new Error(JSON.stringify({"Mensaje_Estatus":token.status,"Mensaje_Error":"Tuvimos un error  en la consulta de token"}));
            }
            const tokenJson =await token.json();

            return await tokenJson;
            
        }
        
        
        /*metodo utilizado para pintar los datos en una tabla creada en html oculta, que con este metodo  se vuelve visible*/
        async function pintar(datosGuia) {
            document.getElementById("filaTracking").hidden=false;
            document.getElementById("Buscar").setAttribute("onclick","location.reload()");
            datosGuia.forEach(function(datosGuia){
                document.getElementById("divTracking").innerHTML+='<tr><td>'+datosGuia.detalleId+'</td><td>'+datosGuia.descripcion+'</td><td>'+datosGuia.dateDelivery+'</td></tr>';
            })

                
        }
        
    }) 
}catch (error) {
    console.error("Hubo un error al cargar el archivo:", error);
}
